/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demos.cityim.internal;

import com.sun.demos.cityim.internal.LookupList;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class CityInputMethod
implements InputMethod {
    private static Locale YOMI = new Locale("ja", "JP", "YOMI");
    private static Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.JAPANESE, YOMI, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
    private static Locale[] LOOKUP_LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.JAPANESE, YOMI, Locale.CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
    private static Properties cityNames;
    private static Properties cityAliases;
    private static Properties cityLanguages;
    private static Properties templates;
    private static Window statusWindow;
    private static CityInputMethod statusWindowOwner;
    private static boolean attachedStatusWindow;
    private Rectangle clientWindowLocation;
    private static Point globalStatusWindowLocation;
    private static HashSet cityInputMethodInstances;
    static Method methodCreateInputMethodJFrame;
    static final String statusWindowTitle = "City Input Method";
    static final String lookupWindowTitle = "Lookup Window";
    private String[] lookupCandidates;
    private Locale[] lookupLocales;
    private int lookupCandidateCount;
    private LookupList lookupList;
    private int lookupSelection;
    InputMethodContext inputMethodContext;
    private boolean active;
    private boolean disposed;
    private Locale locale;
    private boolean converted;
    private StringBuffer rawText;
    private String convertedText;
    private int insertionPoint;
    private String[] rawTextSegs = null;
    private String[] convertedSegs = null;
    private String fmt = null;
    private int[][] fieldPos = null;
    private int[][] segPos = null;
    private int selectedSeg = 0;
    private int numSegs = 0;
    private int committedSeg = -1;
    private int previouslyCommittedCharacterCount = 0;

    public CityInputMethod() throws IOException {
        this.initializeTables();
        this.rawText = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        Window window;
        this.inputMethodContext = inputMethodContext;
        if (statusWindow == null) {
            Object object;
            if (methodCreateInputMethodJFrame != null) {
                try {
                    object = new Object[]{statusWindowTitle, Boolean.FALSE};
                    window = (Window)methodCreateInputMethodJFrame.invoke((Object)inputMethodContext, (Object[])object);
                }
                catch (Exception exception) {
                    window = inputMethodContext.createInputMethodWindow(statusWindowTitle, false);
                }
            } else {
                window = inputMethodContext.createInputMethodWindow(statusWindowTitle, false);
            }
            object = new JLabel();
            ((JComponent)object).setOpaque(true);
            ((JComponent)object).setForeground(Color.black);
            ((JComponent)object).setBackground(Color.white);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (statusWindow == null) {
                    statusWindow = window;
                    statusWindow.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void componentMoved(ComponentEvent componentEvent) {
                            Window window = statusWindow;
                            synchronized (window) {
                                Component component;
                                if (!attachedStatusWindow && (component = componentEvent.getComponent()).isVisible()) {
                                    globalStatusWindowLocation = component.getLocation();
                                }
                            }
                        }

                        @Override
                        public void componentShown(ComponentEvent componentEvent) {
                        }

                        @Override
                        public void componentHidden(ComponentEvent componentEvent) {
                        }
                    });
                    ((Component)object).addMouseListener(new MouseListener(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            int n = mouseEvent.getClickCount();
                            if (n >= 2) {
                                CityInputMethod.this.toggleStatusWindowStyle();
                            }
                        }

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseReleased(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseExited(MouseEvent mouseEvent) {
                        }
                    });
                    if (statusWindow instanceof JFrame) {
                        ((JFrame)statusWindow).getContentPane().add((Component)object);
                    } else {
                        statusWindow.add((Component)object);
                    }
                    statusWindowOwner = this;
                    this.updateStatusWindow(this.locale);
                    ((Component)object).setSize(200, 50);
                    statusWindow.pack();
                }
            }
        }
        this.inputMethodContext.enableClientWindowNotification(this, attachedStatusWindow);
        window = statusWindow;
        synchronized (window) {
            cityInputMethodInstances.add(this);
        }
    }

    @Override
    public boolean setLocale(Locale locale) {
        for (int i = 0; i < SUPPORTED_LOCALES.length; ++i) {
            if (!locale.equals(SUPPORTED_LOCALES[i])) continue;
            this.locale = locale;
            if (statusWindow != null) {
                this.updateStatusWindow(locale);
            }
            return true;
        }
        return false;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStatusWindow(Locale locale) {
        Window window = statusWindow;
        synchronized (window) {
            JLabel jLabel = statusWindow instanceof JFrame ? (JLabel)((JFrame)statusWindow).getContentPane().getComponent(0) : (JLabel)statusWindow.getComponent(0);
            String string = locale == null ? "null" : locale.getDisplayName();
            String string2 = "Current locale: " + string;
            if (!jLabel.getText().equals(string2)) {
                jLabel.setText(string2);
                statusWindow.pack();
            }
            if (attachedStatusWindow) {
                if (this.clientWindowLocation != null) {
                    statusWindow.setLocation(this.clientWindowLocation.x, this.clientWindowLocation.y + this.clientWindowLocation.height);
                }
            } else {
                this.setPCStyleStatusWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPCStyleStatusWindow() {
        Window window = statusWindow;
        synchronized (window) {
            if (globalStatusWindowLocation == null) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                globalStatusWindowLocation = new Point(dimension.width - statusWindow.getWidth(), dimension.height - statusWindow.getHeight() - 25);
            }
            statusWindow.setLocation(CityInputMethod.globalStatusWindowLocation.x, CityInputMethod.globalStatusWindowLocation.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatusWindowForeground(Color color) {
        Window window = statusWindow;
        synchronized (window) {
            if (statusWindowOwner != this) {
                return;
            }
            JLabel jLabel = statusWindow instanceof JFrame ? (JLabel)((JFrame)statusWindow).getContentPane().getComponent(0) : (JLabel)statusWindow.getComponent(0);
            jLabel.setForeground(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleStatusWindowStyle() {
        Window window = statusWindow;
        synchronized (window) {
            if (attachedStatusWindow) {
                attachedStatusWindow = false;
                this.setPCStyleStatusWindow();
            } else {
                attachedStatusWindow = true;
            }
            for (CityInputMethod cityInputMethod : cityInputMethodInstances) {
                cityInputMethod.inputMethodContext.enableClientWindowNotification(cityInputMethod, attachedStatusWindow);
            }
        }
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    @Override
    public void reconvert() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispatchEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        if (!this.active && aWTEvent instanceof KeyEvent) {
            System.out.println("CityInputMethod.dispatch called with KeyEvent while not active");
        }
        if (this.disposed) {
            System.out.println("CityInputMethod.dispatch called after being disposed");
        }
        if (!(aWTEvent instanceof InputEvent)) {
            System.out.println("CityInputMethod.dispatch called with event that's not an InputEvent");
        }
        InputEvent inputEvent = (InputEvent)aWTEvent;
        Component component = inputEvent.getComponent();
        if (inputEvent.isConsumed() || null == component || !component.isShowing()) {
            return;
        }
        int n = aWTEvent.getID();
        if (n == 402) {
            KeyEvent keyEvent2 = (KeyEvent)aWTEvent;
            int n2 = keyEvent2.getKeyCode();
            if (this.lookupList != null) {
                if (keyEvent2.isControlDown()) {
                    if (n2 == 40) {
                        this.closeLookupWindow();
                        this.commit(this.selectedSeg);
                        keyEvent2.consume();
                    }
                } else if (n2 == 40) {
                    if (++this.lookupSelection == this.lookupCandidateCount) {
                        this.lookupSelection = 0;
                    }
                    this.selectCandidate(this.lookupSelection);
                    keyEvent2.consume();
                } else if (n2 == 38) {
                    if (--this.lookupSelection < 0) {
                        this.lookupSelection = this.lookupCandidateCount;
                    }
                    this.selectCandidate(this.lookupSelection);
                    keyEvent2.consume();
                }
            } else if (keyEvent2.isControlDown()) {
                if (n2 == 40) {
                    this.commit(this.selectedSeg);
                    keyEvent2.consume();
                }
            } else if (n2 == 39 && this.converted) {
                if (this.selectedSeg < this.numSegs - 1) {
                    ++this.selectedSeg;
                    this.sendText(false);
                    keyEvent2.consume();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (n2 == 37 && this.converted) {
                if (this.selectedSeg > this.committedSeg + 1) {
                    --this.selectedSeg;
                    this.sendText(false);
                    keyEvent2.consume();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        } else if (n == 500) {
            int n3;
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Point point = component.getLocationOnScreen();
            int n4 = (int)point.getX() + mouseEvent.getX();
            TextHitInfo textHitInfo = this.inputMethodContext.getLocationOffset(n4, n3 = (int)point.getY() + mouseEvent.getY());
            if (textHitInfo != null) {
                if (this.converted) {
                    this.selectedSeg = this.findSegment(textHitInfo.getInsertionIndex());
                    this.sendText(false);
                    mouseEvent.consume();
                } else {
                    this.insertionPoint = textHitInfo.getInsertionIndex();
                }
            } else {
                this.commitAll();
            }
        } else if (n == 400) {
            KeyEvent keyEvent3 = (KeyEvent)aWTEvent;
            if (this.handleCharacter(keyEvent3.getKeyChar())) {
                keyEvent3.consume();
            }
        } else if (n == 401 && (keyEvent = (KeyEvent)aWTEvent).getKeyCode() == 10 && (this.lookupList != null || this.converted || this.rawText.length() != 0)) {
            keyEvent.consume();
        }
    }

    int findSegment(int n) {
        for (int i = this.committedSeg + 1; i < this.numSegs; ++i) {
            if (this.segPos[i][0] >= n || n >= this.segPos[i][1]) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        if (this.active) {
            System.out.println("CityInputMethod.activate called while active");
        }
        this.active = true;
        Window window = statusWindow;
        synchronized (window) {
            statusWindowOwner = this;
            this.updateStatusWindow(this.locale);
            if (!statusWindow.isVisible()) {
                statusWindow.setVisible(true);
            }
            this.setStatusWindowForeground(Color.black);
        }
    }

    @Override
    public void deactivate(boolean bl) {
        this.closeLookupWindow();
        if (!this.active) {
            System.out.println("CityInputMethod.deactivate called while not active");
        }
        this.setStatusWindowForeground(Color.lightGray);
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideWindows() {
        if (this.active) {
            System.out.println("CityInputMethod.hideWindows called while active");
        }
        this.closeLookupWindow();
        Window window = statusWindow;
        synchronized (window) {
            if (statusWindowOwner == this) {
                statusWindow.setVisible(false);
            }
        }
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public void endComposition() {
        if (this.rawText.length() != 0) {
            this.commitAll();
        }
        this.closeLookupWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyClientWindowChange(Rectangle rectangle) {
        this.clientWindowLocation = rectangle;
        Window window = statusWindow;
        synchronized (window) {
            if (!attachedStatusWindow || statusWindowOwner != this) {
                return;
            }
            if (rectangle != null) {
                statusWindow.setLocation(rectangle.x, rectangle.y + rectangle.height);
                if (!statusWindow.isVisible()) {
                    if (this.active) {
                        this.setStatusWindowForeground(Color.black);
                    } else {
                        this.setStatusWindowForeground(Color.lightGray);
                    }
                    statusWindow.setVisible(true);
                }
            } else {
                statusWindow.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.active) {
            System.out.println("CityInputMethod.dispose called while active");
        }
        if (this.disposed) {
            System.out.println("CityInputMethod.disposed called repeatedly");
        }
        this.closeLookupWindow();
        Window window = statusWindow;
        synchronized (window) {
            cityInputMethodInstances.remove(this);
            if (cityInputMethodInstances.isEmpty()) {
                statusWindow.dispose();
            }
        }
        this.disposed = true;
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    @Override
    public void setCompositionEnabled(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompositionEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTables() throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (templates == null) {
                cityNames = this.loadProperties("names.properties");
                cityAliases = this.loadProperties("aliases.properties");
                cityLanguages = this.loadProperties("languages.properties");
                templates = this.loadProperties("templates.properties");
            }
        }
    }

    private Properties loadProperties(final String string) throws IOException {
        try {
            return (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Properties properties = new Properties();
                    InputStream inputStream = this.getClass().getResourceAsStream(string);
                    properties.load(inputStream);
                    inputStream.close();
                    return properties;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private boolean handleCharacter(char c) {
        if (this.lookupList != null) {
            if (c == ' ') {
                if (++this.lookupSelection == this.lookupCandidateCount) {
                    this.lookupSelection = 0;
                }
                this.selectCandidate(this.lookupSelection);
                return true;
            }
            if (c == '\n') {
                this.commitAll();
                this.closeLookupWindow();
                return true;
            }
            if ('1' <= c && c <= 48 + this.lookupCandidateCount) {
                this.selectCandidate(c - 49);
                this.closeLookupWindow();
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
            return true;
        }
        if (this.converted) {
            if (c == ' ') {
                this.convertAgain();
                return true;
            }
            if (c == '\n') {
                this.commitAll();
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
            return true;
        }
        if (c == ' ') {
            int n = this.rawText.length();
            if (n == 3 || n == 6 || n == 9) {
                this.convertFirstTime();
                return true;
            }
        } else if (c == '\n') {
            if (this.rawText.length() != 0) {
                this.commitAll();
                return true;
            }
        } else if (c == '\b') {
            if (this.insertionPoint > 0) {
                this.rawText.deleteCharAt(this.insertionPoint - 1);
                --this.insertionPoint;
                this.sendText(false);
                return true;
            }
        } else if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            this.rawText.insert(this.insertionPoint++, c);
            this.sendText(false);
            return true;
        }
        if (this.rawText.length() != 0) {
            Toolkit.getDefaultToolkit().beep();
            return true;
        }
        return false;
    }

    String lookup(String string, Properties properties) {
        int n;
        String string2 = null;
        String string3 = string + "_" + this.locale;
        while ((string2 = (String)properties.get(string3)) == null && (n = string3.lastIndexOf("_")) != -1) {
            string3 = string3.substring(0, n);
        }
        return string2;
    }

    String findAlias(String string) {
        string = string.toUpperCase();
        return cityAliases.getProperty(string, string);
    }

    void convertFirstTime() {
        this.numSegs = this.rawText.length() / 3;
        this.rawTextSegs = new String[this.numSegs];
        this.convertedSegs = new String[this.numSegs];
        for (int i = 0; i < this.numSegs; ++i) {
            this.rawTextSegs[i] = this.rawText.substring(i * 3, (i + 1) * 3);
            String string = this.findAlias(this.rawTextSegs[i]);
            String string2 = this.lookup(string, cityNames);
            this.convertedSegs[i] = string2 != null ? string2 : this.rawText.substring(i * 3, (i + 1) * 3);
        }
        this.converted = true;
        this.sendText(false);
    }

    void convertAgain() {
        String string = this.rawTextSegs[this.selectedSeg];
        if (!string.equals(this.convertedSegs[this.selectedSeg])) {
            string = this.findAlias(string);
            this.lookupCandidates = new String[LOOKUP_LOCALES.length];
            this.lookupLocales = new Locale[LOOKUP_LOCALES.length];
            this.lookupCandidateCount = 0;
            this.lookupSelection = 0;
            for (int i = 0; i < LOOKUP_LOCALES.length; ++i) {
                Locale locale = LOOKUP_LOCALES[i];
                String string2 = string + '_' + locale;
                String string3 = (String)cityNames.get(string2);
                if (string3 != null) {
                    this.lookupCandidates[this.lookupCandidateCount] = string3;
                    this.lookupLocales[this.lookupCandidateCount] = locale;
                    ++this.lookupCandidateCount;
                } else if (locale.equals(Locale.ENGLISH) && (string3 = (String)cityNames.get(string)) != null) {
                    this.lookupCandidates[this.lookupCandidateCount] = string3;
                    this.lookupLocales[this.lookupCandidateCount] = locale;
                    ++this.lookupCandidateCount;
                }
                if (!this.convertedSegs[this.selectedSeg].equals(string3)) continue;
                this.lookupSelection = this.lookupCandidateCount - 1;
            }
            this.openLookupWindow();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void commit(int n) {
        if (n >= this.numSegs - 1) {
            this.commitAll();
        } else {
            this.committedSeg = n;
            this.selectedSeg = this.committedSeg + 1;
            this.sendText(true);
        }
    }

    void commitAll() {
        this.committedSeg = this.numSegs - 1;
        this.sendText(true);
        this.rawText.setLength(0);
        this.convertedText = null;
        this.converted = false;
        this.rawTextSegs = null;
        this.convertedSegs = null;
        this.fmt = null;
        this.fieldPos = null;
        this.segPos = null;
        this.selectedSeg = 0;
        this.insertionPoint = this.rawText.length();
        this.numSegs = 0;
        this.committedSeg = -1;
        this.previouslyCommittedCharacterCount = 0;
    }

    void parseFormat() {
        Vector<int[]> vector = new Vector<int[]>();
        int[] nArray = null;
        for (int i = 0; i < this.fmt.length(); ++i) {
            if (this.fmt.charAt(i) == '{') {
                nArray = new int[2];
                nArray[0] = i;
                continue;
            }
            if (this.fmt.charAt(i) != '}') continue;
            nArray[1] = i;
            vector.add(nArray);
        }
        if (vector.size() != 0) {
            this.fieldPos = new int[vector.size()][];
            vector.toArray((T[])this.fieldPos);
        }
    }

    void formatOutput() {
        if (this.fmt == null) {
            String string = "Template" + Integer.toString(this.numSegs);
            this.fmt = this.lookup(string, templates);
            this.parseFormat();
        }
        this.convertedText = MessageFormat.format(this.fmt, this.convertedSegs);
        int n = 0;
        this.segPos = new int[this.fieldPos.length][2];
        for (int i = 0; i < this.fieldPos.length; ++i) {
            int n2 = this.fieldPos[i][1] - this.fieldPos[i][0] + 1;
            int n3 = this.convertedSegs[i].length() - n2;
            this.segPos[i][0] = this.fieldPos[i][0] + n;
            this.segPos[i][1] = this.segPos[i][0] + this.convertedSegs[i].length();
            n += n3;
        }
    }

    void sendText(boolean bl) {
        AttributedString attributedString = null;
        TextHitInfo textHitInfo = null;
        int n = 0;
        int n2 = this.previouslyCommittedCharacterCount;
        if (this.converted) {
            this.formatOutput();
            if (bl) {
                n2 = this.committedSeg == this.numSegs - 1 ? this.convertedText.length() : this.segPos[this.committedSeg + 1][0];
                n = n2 - this.previouslyCommittedCharacterCount;
            }
            attributedString = new AttributedString(this.convertedText.substring(this.previouslyCommittedCharacterCount));
            for (int i = this.committedSeg + 1; i < this.numSegs; ++i) {
                InputMethodHighlight inputMethodHighlight = i == this.selectedSeg ? InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT : InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, this.segPos[i][0] - this.previouslyCommittedCharacterCount, this.segPos[i][1] - this.previouslyCommittedCharacterCount);
            }
            this.previouslyCommittedCharacterCount = n2;
        } else {
            attributedString = new AttributedString(this.rawText.toString());
            if (bl) {
                n = this.rawText.length();
            } else if (this.rawText.length() != 0) {
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT);
                textHitInfo = TextHitInfo.leading(this.insertionPoint);
            }
        }
        this.inputMethodContext.dispatchInputMethodEvent(1100, attributedString.getIterator(), n, textHitInfo, null);
    }

    void selectCandidate(int n) {
        this.lookupSelection = n;
        this.lookupList.selectCandidate(this.lookupSelection);
        this.convertedSegs[this.selectedSeg] = this.lookupCandidates[this.lookupSelection];
        this.sendText(false);
    }

    int getSelectedSegmentOffset() {
        return this.segPos[this.selectedSeg][0] - this.previouslyCommittedCharacterCount;
    }

    void openLookupWindow() {
        this.lookupList = new LookupList(this, this.inputMethodContext, this.lookupCandidates, this.lookupLocales, this.lookupCandidateCount);
        this.lookupList.selectCandidate(this.lookupSelection);
    }

    void closeLookupWindow() {
        if (this.lookupList != null) {
            this.lookupList.setVisible(false);
            this.lookupList = null;
        }
    }

    static {
        attachedStatusWindow = false;
        cityInputMethodInstances = new HashSet(5);
        methodCreateInputMethodJFrame = null;
        methodCreateInputMethodJFrame = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class[] classArray = new Class[]{String.class, Boolean.TYPE};
                    return InputMethodContext.class.getMethod("createInputMethodJFrame", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
    }
}

