/*
 * Decompiled with CFR 0.152.
 */
package modele.jeu;

import configuration.Parametres;
import modele.mangeables.Mangeable;
import modele.mangeables.Radis;
import modele.mangeables.Riz;

public class Inventaire {
    private int nombreTomates;
    private int nombreRadis;
    private int nombreRiz;
    private Parametres parametres;

    public Inventaire(Parametres p) {
        this.parametres = p;
        this.nombreTomates = this.parametres.nbTomateCaissette;
        this.nombreRiz = this.parametres.nbRizCaissette;
        this.nombreRadis = this.parametres.nbRadisCaissette;
    }

    public void enleverObjet(Mangeable m) {
        if (m instanceof Radis) {
            --this.nombreRadis;
        } else if (m instanceof Riz) {
            --this.nombreRiz;
        } else {
            --this.nombreTomates;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enleverObjet(Mangeable m, int quantite) {
        if (m instanceof Radis) {
            if (quantite > this.nombreRadis) throw new Error("impossible d'enlever autant d'occurences de cet objet");
            this.nombreRadis -= quantite;
            return;
        } else if (m instanceof Riz) {
            if (quantite > this.nombreRiz) throw new Error("impossible d'enlever autant d'occurences de cet objet");
            this.nombreRiz -= quantite;
            return;
        } else {
            if (quantite > this.nombreTomates) throw new Error("impossible d'enlever autant d'occurences de cet objet");
            this.nombreTomates -= quantite;
        }
    }

    public void enleverObjet(String nom) {
        if (nom.equals("radis")) {
            --this.nombreRadis;
        } else if (nom.equals("riz")) {
            --this.nombreRiz;
        } else {
            --this.nombreTomates;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enleverObjet(String nom, int quantite) {
        if (nom.equals("radis")) {
            if (quantite > this.nombreRadis) throw new Error("impossible d'enlever autant d'occurences de cet objet");
            this.nombreRadis -= quantite;
            return;
        } else if (nom.equals("riz")) {
            if (quantite > this.nombreRiz) throw new Error("impossible d'enlever autant d'occurences de cet objet");
            this.nombreRiz -= quantite;
            return;
        } else {
            if (quantite > this.nombreTomates) throw new Error("impossible d'enlever autant d'occurences de cet objet");
            this.nombreTomates -= quantite;
        }
    }

    public void ajouterObjet(Mangeable m) {
        if (m instanceof Radis) {
            ++this.nombreRadis;
        } else if (m instanceof Riz) {
            ++this.nombreRiz;
        } else {
            ++this.nombreTomates;
        }
    }

    public void ajouterObjet(Mangeable m, int quantite) {
        if (m instanceof Radis) {
            this.nombreRadis += quantite;
        } else if (m instanceof Riz) {
            this.nombreRiz += quantite;
        } else {
            this.nombreTomates += quantite;
        }
    }

    public void ajouterObjet(String nom) {
        if (nom.equals("radis")) {
            ++this.nombreRadis;
        } else if (nom.equals("riz")) {
            ++this.nombreRiz;
        } else {
            ++this.nombreTomates;
        }
    }

    public void ajouterObjet(String nom, int quantite) {
        if (nom.equals("radis")) {
            this.nombreRadis += quantite;
        } else if (nom.equals("riz")) {
            this.nombreRiz += quantite;
        } else {
            this.nombreTomates += quantite;
        }
    }

    public void viderInventaire() {
        this.nombreRadis = 0;
        this.nombreTomates = 0;
        this.nombreRiz = 0;
    }

    public boolean estVide() {
        return this.nombreRadis == 0 && this.nombreRiz == 0 && this.nombreTomates == 0;
    }

    public int getNombreRadis() {
        return this.nombreRadis;
    }

    public int getNombreRiz() {
        return this.nombreRiz;
    }

    public int getNombreTomates() {
        return this.nombreTomates;
    }

    public int getNombreObjets() {
        return this.nombreRadis + this.nombreRiz + this.nombreTomates;
    }
}

