/*
 * Decompiled with CFR 0.152.
 */
package modele.jeu;

import configuration.Parametres;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import modele.jeu.Inventaire;
import modele.mangeables.Mangeable;
import modele.mangeables.Radis;
import modele.mangeables.Riz;
import modele.mangeables.Tomate;
import modele.terrain.ParcelleCultivable;
import modele.terrain.ParcelleEau;
import modele.terrain.Terrain;
import outils.Coordonnees;

public class Jeu {
    private Terrain terrain;
    private Inventaire inventaire;
    private int nbTour;
    private int pa;
    private int besoinManger;
    private boolean gagner;
    private boolean fini;
    private PropertyChangeSupport pcsParcelle;
    private PropertyChangeSupport pcsRessources;
    private PropertyChangeSupport pcsMessages;
    private Parametres parametres;

    public Jeu(Terrain terrain, Parametres p) {
        this.parametres = p;
        this.terrain = terrain;
        this.inventaire = new Inventaire(this.parametres);
        this.nbTour = 1;
        this.pa = 2;
        this.besoinManger = 0;
        this.pcsParcelle = new PropertyChangeSupport(this);
        this.pcsRessources = new PropertyChangeSupport(this);
        this.pcsMessages = new PropertyChangeSupport(this);
    }

    public void lancer() {
        this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
    }

    public void planter(Coordonnees c, Mangeable m) {
        try {
            this.planterGeneral(c, m);
        }
        catch (Error e) {
            this.pcsMessages.firePropertyChange("erreur", e.getMessage(), null);
            this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void planterGeneral(Coordonnees c, Mangeable m) {
        if (this.pa < 1) throw new Error("Vous n'avez pas assez de points d'action pour accomplir cette action.");
        if (this.inventaire.estVide()) throw new Error("Vous n'avez rien \u00e0 planter.");
        if (!(this.terrain.getParcelle(c) instanceof ParcelleCultivable) || this.terrain.getParcelle(c).getEtat()) throw new Error("Impossible de planter ici.");
        if (((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable() != null) throw new Error("Il y a d\u00e9j\u00e0 un mangeable ici.");
        if (m instanceof Radis) {
            if (this.terrain.calculerNombreDeParcellesAdjacentes(c, new ParcelleEau()) < ((Radis)m).getBesoinIrrigation()) throw new Error("Il n'y a pas assez d'eau pour planter ici.");
            ((ParcelleCultivable)this.terrain.getParcelle(c)).setMangeable(m);
            this.pcsParcelle.firePropertyChange("planter", "radis", c);
        }
        if (m instanceof Tomate) {
            if (this.terrain.calculerNombreDeParcellesAdjacentes(c, new ParcelleEau()) < ((Tomate)m).getBesoinIrrigation()) throw new Error("Il n'y a pas assez d'eau pour planter ici.");
            ((ParcelleCultivable)this.terrain.getParcelle(c)).setMangeable(m);
            this.pcsParcelle.firePropertyChange("planter", "tomate", c);
        }
        if (m instanceof Riz) {
            if (this.terrain.calculerNombreDeParcellesAdjacentes(c, new ParcelleEau()) < ((Riz)m).getBesoinIrrigation()) throw new Error("Il n'y a pas assez d'eau pour planter ici.");
            ((ParcelleCultivable)this.terrain.getParcelle(c)).setMangeable(m);
            this.pcsParcelle.firePropertyChange("planter", "riz", c);
        }
        this.inventaire.enleverObjet(m);
        --this.pa;
        this.pcsMessages.firePropertyChange("succes", "Votre " + this.typeMangeable(m) + " a bien \u00e9t\u00e9 plant\u00e9. Il sera r\u00e9coltable dans " + m.getToursAvantCueillette() + " tour(s).", null);
        this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
    }

    public void recolter(Coordonnees c) {
        try {
            this.recolterGeneral(c);
        }
        catch (Error e) {
            this.pcsMessages.firePropertyChange("erreur", e.getMessage(), null);
            this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recolterGeneral(Coordonnees c) {
        if (this.pa < 1) throw new Error("Vous n'avez pas assez de points d'action pour accomplir cette action.");
        if (!(this.terrain.getParcelle(c) instanceof ParcelleCultivable)) throw new Error("Impossible de recolter ici.");
        if (((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable() == null) throw new Error("Il n'y a rien \u00e0 recolter sur cette parcelle.");
        if (((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable().getToursAvantCueillette() != 0) throw new Error("Ce mangeable n'est pas encore r\u00e9coltable.");
        Mangeable m = ((ParcelleCultivable)this.terrain.getParcelle(c)).recolter();
        this.inventaire.ajouterObjet(m, m.getRendement());
        --this.pa;
        this.pcsParcelle.firePropertyChange("recolter", new ParcelleCultivable(false), c);
        this.pcsMessages.firePropertyChange("succes", "Vous avez bien r\u00e9colt\u00e9.", null);
        this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
    }

    public void irriguer(Coordonnees c) {
        try {
            this.irriguerGeneral(c);
        }
        catch (Error e) {
            this.pcsMessages.firePropertyChange("erreur", e.getMessage(), null);
            this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void irriguerGeneral(Coordonnees c) {
        int x = c.getX();
        int y = c.getY();
        if (this.pa < 1) throw new Error("Vous n'avez pas assez de points d'action pour accomplir cette action.");
        if (!(y + 1 < this.terrain.getTailleV() && this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau || y - 1 >= 0 && this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau || x + 1 < this.terrain.getTailleH() && this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau) && (x - 1 < 0 || !(this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau)) || !(this.terrain.getParcelle(c) instanceof ParcelleCultivable)) throw new Error("Impossible d'irriguer cette parcelle.");
        this.terrain.setParcelle(c, new ParcelleEau());
        --this.pa;
        this.pcsParcelle.firePropertyChange("irriguer", new ParcelleEau(), c);
        this.pcsMessages.firePropertyChange("succes", "La parcelle a bien \u00e9t\u00e9 irrigu\u00e9e.", null);
        this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
    }

    public void defricher(Coordonnees c) {
        try {
            this.defricherGeneral(c);
        }
        catch (Error e) {
            this.pcsMessages.firePropertyChange("erreur", e.getMessage(), null);
            this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defricherGeneral(Coordonnees c) {
        if (this.pa < 1) throw new Error("Vous n'avez pas assez de points d'action pour accomplir cette action.");
        if (!(this.terrain.getParcelle(c) instanceof ParcelleCultivable) || !this.terrain.getParcelle(c).getEtat()) throw new Error("Cette parcelle est d\u00e9j\u00e0 d\u00e9frich\u00e9e ou n'est pas d\u00e9frichable.");
        ((ParcelleCultivable)this.terrain.getParcelle(c)).setEtat(false);
        --this.pa;
        this.pcsParcelle.firePropertyChange("defricher", new ParcelleCultivable(false), c);
        this.pcsMessages.firePropertyChange("succes", "La parcelle a bien \u00e9t\u00e9 d\u00e9frich\u00e9e.", null);
        this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
    }

    public void passerTour() {
        if (this.nbTour == this.parametres.limiteDeTours) {
            this.fini = true;
            this.gagner = true;
        } else {
            ++this.nbTour;
            this.pa = 2;
            for (int i = 0; i < this.terrain.getTailleH(); ++i) {
                for (int j = 0; j < this.terrain.getTailleV(); ++j) {
                    if (!(this.terrain.getParcelle(i, j) instanceof ParcelleCultivable) || ((ParcelleCultivable)this.terrain.getParcelle(i, j)).getMangeable() == null) continue;
                    ((ParcelleCultivable)this.terrain.getParcelle(i, j)).croitre();
                    this.pcsParcelle.firePropertyChange("croitre", this.terrain.getParcelle(i, j), new Coordonnees(i, j));
                }
            }
        }
        this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
    }

    public void manger(Mangeable m) {
        try {
            this.mangerGeneral(m);
        }
        catch (Error e) {
            this.pcsMessages.firePropertyChange("erreur", e.getMessage(), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mangerGeneral(Mangeable m) {
        if (this.inventaire.estVide()) throw new Error("Votre inventaire est vide.");
        if (m instanceof Radis) {
            if (this.inventaire.getNombreRadis() < 1) throw new Error("Vous n'avez pas de radis.");
            this.inventaire.enleverObjet(m);
        }
        if (m instanceof Tomate) {
            if (this.inventaire.getNombreTomates() < 1) throw new Error("Vous n'avez pas de tomate.");
            this.inventaire.enleverObjet(m);
        }
        if (m instanceof Riz) {
            if (this.inventaire.getNombreRiz() < 1) throw new Error("Vous n'avez pas de riz.");
            this.inventaire.enleverObjet(m);
        }
        this.pcsMessages.firePropertyChange("succes", "Vous avez bien mang\u00e9 un \"" + this.typeMangeable(m) + "\"", null);
    }

    public int getPA() {
        return this.pa;
    }

    public int getNbTour() {
        return this.nbTour;
    }

    public boolean getGagner() {
        return this.gagner;
    }

    public boolean getFini() {
        return this.fini;
    }

    public void setFini(boolean b) {
        this.fini = b;
    }

    public void setGagner(boolean b) {
        this.gagner = b;
    }

    public void calculerBesoinManger() {
        if (this.nbTour <= 3) {
            this.besoinManger = 0;
        } else if ((this.nbTour - 3) % this.parametres.nombreDeToursParPalierDeConsommation == 1) {
            ++this.besoinManger;
        }
        if (this.besoinManger > this.inventaire.getNombreObjets()) {
            this.besoinManger = -1;
            this.gagner = false;
            this.fini = true;
            this.pcsRessources.firePropertyChange("ressources", "ancienne", "nouvelle");
        }
    }

    public int getBesoinManger() {
        return this.besoinManger;
    }

    public int getNombreRadis() {
        return this.inventaire.getNombreRadis();
    }

    public int getNombreTomates() {
        return this.inventaire.getNombreTomates();
    }

    public int getNombreRiz() {
        return this.inventaire.getNombreRiz();
    }

    public void ajouterEcouteurParcelle(PropertyChangeListener ecouteur) {
        this.pcsParcelle.addPropertyChangeListener(ecouteur);
    }

    public void retirerEcouteurParcelle(PropertyChangeListener ecouteur) {
        this.pcsParcelle.removePropertyChangeListener(ecouteur);
    }

    public void ajouterEcouteurRessources(PropertyChangeListener ecouteur) {
        this.pcsRessources.addPropertyChangeListener(ecouteur);
    }

    public void retirerEcouteurRessources(PropertyChangeListener ecouteur) {
        this.pcsRessources.removePropertyChangeListener(ecouteur);
    }

    public void ajouterEcouteurMessages(PropertyChangeListener ecouteur) {
        this.pcsMessages.addPropertyChangeListener(ecouteur);
    }

    public void retirerEcouteurMessages(PropertyChangeListener ecouteur) {
        this.pcsMessages.removePropertyChangeListener(ecouteur);
    }

    private String typeMangeable(Mangeable m) {
        String nom = "";
        if (m instanceof Radis) {
            nom = "radis";
        }
        if (m instanceof Tomate) {
            nom = "tomate";
        }
        if (m instanceof Riz) {
            nom = "riz";
        }
        return nom;
    }

    public Parametres getParametre() {
        return this.parametres;
    }
}

