/*
 * Decompiled with CFR 0.152.
 */
package modele.terrain;

import java.util.ArrayList;
import modele.terrain.ParcelleAbstraite;
import outils.Coordonnees;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Terrain {
    private ParcelleAbstraite[][] parcelles;

    public Terrain(int tailleH, int tailleV) {
        this.parcelles = new ParcelleAbstraite[tailleV][tailleH];
    }

    public void setParcelle(int x, int y, ParcelleAbstraite p) {
        this.parcelles[y][x] = p;
    }

    public void setParcelle(Coordonnees c, ParcelleAbstraite p) {
        this.parcelles[c.getY()][c.getX()] = p;
    }

    public ParcelleAbstraite getParcelle(int x, int y) {
        return this.parcelles[y][x];
    }

    public ParcelleAbstraite getParcelle(Coordonnees c) {
        return this.parcelles[c.getY()][c.getX()];
    }

    public int getTailleH() {
        return this.parcelles[0].length;
    }

    public int getTailleV() {
        return this.parcelles.length;
    }

    public int calculerNombreDeParcellesAdjacentes(Coordonnees c, ParcelleAbstraite parcelle) {
        int n = 0;
        int x = c.getX();
        int y = c.getY();
        if (x - 1 >= 0 && y - 1 >= 0 && this.getParcelle(x - 1, y - 1).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (x - 1 >= 0 && y + 1 < this.getTailleV() && this.getParcelle(x - 1, y).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (x - 1 >= 0 && y + 1 < this.getTailleV() && this.getParcelle(x - 1, y + 1).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (y - 1 >= 0 && this.getParcelle(x, y - 1).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (y + 1 < this.getTailleV() && this.getParcelle(x, y + 1).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (y - 1 >= 0 && x + 1 < this.getTailleH() && this.getParcelle(x + 1, y - 1).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (x + 1 < this.getTailleH() && this.getParcelle(x + 1, y).getClass() == parcelle.getClass()) {
            ++n;
        }
        if (x + 1 < this.getTailleH() && y + 1 < this.getTailleV() && this.getParcelle(x + 1, y + 1).getClass() == parcelle.getClass()) {
            ++n;
        }
        return n;
    }

    public ArrayList<Coordonnees> coordonneesDeParcellesAdjacentes(Coordonnees c, ParcelleAbstraite parcelle) {
        ArrayList<Coordonnees> listeCoord = new ArrayList<Coordonnees>();
        int x = c.getX();
        int y = c.getY();
        if (x - 1 >= 0 && y - 1 >= 0 && this.getParcelle(x - 1, y - 1).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x - 1, y - 1));
        }
        if (x - 1 >= 0 && y + 1 < this.getTailleV() && this.getParcelle(x - 1, y).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x - 1, y));
        }
        if (x - 1 >= 0 && y + 1 < this.getTailleV() && this.getParcelle(x - 1, y + 1).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x - 1, y + 1));
        }
        if (y - 1 >= 0 && this.getParcelle(x, y - 1).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x, y - 1));
        }
        if (y + 1 < this.getTailleV() && this.getParcelle(x, y + 1).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x, y + 1));
        }
        if (y - 1 >= 0 && x + 1 < this.getTailleH() && this.getParcelle(x + 1, y - 1).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x + 1, y - 1));
        }
        if (x + 1 < this.getTailleH() && this.getParcelle(x + 1, y).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x + 1, y));
        }
        if (x + 1 < this.getTailleH() && y + 1 < this.getTailleV() && this.getParcelle(x + 1, y + 1).getClass() == parcelle.getClass()) {
            listeCoord.add(new Coordonnees(x + 1, y + 1));
        }
        return listeCoord;
    }

    public void croitre() {
        for (int i = 0; i < this.parcelles.length; ++i) {
            for (int j = 0; j < this.parcelles[i].length; ++j) {
                this.parcelles[i][j].croitre();
            }
        }
    }
}

