/*
 * Decompiled with CFR 0.152.
 */
package vue.console;

import configuration.Parametres;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Scanner;
import modele.jeu.Jeu;
import modele.mangeables.Mangeable;
import modele.mangeables.Radis;
import modele.mangeables.Riz;
import modele.mangeables.Tomate;
import modele.terrain.ParcelleCultivable;
import modele.terrain.ParcelleEau;
import modele.terrain.ParcelleRocher;
import modele.terrain.Terrain;
import outils.Coordonnees;

public class AfficheurConsole {
    private Terrain terrain;
    private Jeu jeu;
    private Parametres parametre;

    public AfficheurConsole(Terrain plateau, Jeu jeu) {
        this.terrain = plateau;
        this.jeu = jeu;
        this.parametre = this.jeu.getParametre();
        this.jeu.ajouterEcouteurRessources(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (AfficheurConsole.this.jeu.getFini()) {
                    if (AfficheurConsole.this.jeu.getGagner()) {
                        System.out.println("F\u00e9licitations, vous avez gagn\u00e9 !");
                    } else {
                        System.out.println("Malheureusement, vous avez perdu...");
                    }
                } else if (AfficheurConsole.this.jeu.getPA() == 0) {
                    AfficheurConsole.this.passerTour();
                } else {
                    AfficheurConsole.this.afficherPlateau();
                    AfficheurConsole.this.lancerMenu();
                }
            }
        });
        this.jeu.ajouterEcouteurMessages(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                System.out.println(e.getOldValue());
                AfficheurConsole.this.saisirString();
            }
        });
    }

    public void afficherPlateau() {
        System.out.println("Tour " + this.jeu.getNbTour() + "/" + this.parametre.limiteDeTours + "\n");
        for (int i = 0; i < this.terrain.getTailleH(); ++i) {
            System.out.print("   " + (i + 1));
        }
        for (int ind1 = 0; ind1 < this.terrain.getTailleH(); ++ind1) {
            System.out.print("\n" + (ind1 + 1));
            for (int ind2 = 0; ind2 < this.terrain.getTailleV(); ++ind2) {
                if (this.terrain.getParcelle(ind2, ind1) instanceof ParcelleCultivable) {
                    if (this.terrain.getParcelle(ind2, ind1).getEtat()) {
                        System.out.print("  _ ");
                    } else if (((ParcelleCultivable)this.terrain.getParcelle(ind2, ind1)).getMangeable() == null) {
                        System.out.print("  . ");
                    } else {
                        if (((ParcelleCultivable)this.terrain.getParcelle(ind2, ind1)).getMangeable() instanceof Radis) {
                            System.out.print(" Ra ");
                        }
                        if (((ParcelleCultivable)this.terrain.getParcelle(ind2, ind1)).getMangeable() instanceof Riz) {
                            System.out.print(" Ri ");
                        }
                        if (((ParcelleCultivable)this.terrain.getParcelle(ind2, ind1)).getMangeable() instanceof Tomate) {
                            System.out.print("  T ");
                        }
                    }
                }
                if (this.terrain.getParcelle(ind2, ind1) instanceof ParcelleEau) {
                    System.out.print(" )))");
                }
                if (!(this.terrain.getParcelle(ind2, ind1) instanceof ParcelleRocher)) continue;
                System.out.print(" @@@");
            }
        }
        System.out.println();
    }

    public void lancerMenu() {
        int choix;
        System.out.println("Radis : " + this.jeu.getNombreRadis() + "\tTomate : " + this.jeu.getNombreTomates() + "\t Riz : " + this.jeu.getNombreRiz() + "\tPA : " + this.jeu.getPA());
        do {
            try {
                System.out.println("1. Planter\n2. R\u00e9colter\n3. Irriguer\n4. D\u00e9fricher\n9. Afficher la l\u00e9gende\n0. Passer au tour suivant\nQue faites-vous ?");
                Scanner sc = new Scanner(System.in);
                choix = sc.nextInt();
                this.gererMenu(choix);
            }
            catch (Exception e) {
                System.out.println("Vous devez entrer un entier !");
                choix = -1;
            }
        } while (choix == -1);
    }

    public void gererMenu(int choix) {
        switch (choix) {
            case 1: {
                this.planter();
                break;
            }
            case 2: {
                this.recolter();
                break;
            }
            case 3: {
                this.irriguer();
                break;
            }
            case 4: {
                this.defricher();
                break;
            }
            case 9: {
                this.afficherLegende();
                break;
            }
            case 0: {
                this.passerTour();
                break;
            }
            default: {
                System.out.println("Mauvais choix");
                this.saisirString();
                this.afficherPlateau();
                this.lancerMenu();
            }
        }
    }

    public void planter() {
        boolean aPlante;
        String nom = "";
        Mangeable m = null;
        do {
            System.out.println("Que voulez-vous planter ? ('annuler' pour annuler)");
            nom = this.saisirString();
            nom = nom.toLowerCase();
            aPlante = false;
            if (nom.equals("tomate") && this.jeu.getNombreTomates() >= 1) {
                m = new Tomate();
                aPlante = true;
            }
            if (nom.equals("radis") && this.jeu.getNombreRadis() >= 1) {
                m = new Radis();
                aPlante = true;
            }
            if (nom.equals("riz") && this.jeu.getNombreRiz() >= 1) {
                m = new Riz();
                aPlante = true;
            }
            if (!nom.equals("annuler")) continue;
            aPlante = true;
        } while (!aPlante);
        if (!nom.equals("annuler")) {
            System.out.println("O\u00f9 voulez-vous planter ? (0 pour annuler)");
            Coordonnees c = this.saisirCoordonnees();
            if (c.getX() != -1 && c.getY() != -1) {
                this.jeu.planter(c, m);
            } else {
                this.afficherPlateau();
                this.lancerMenu();
            }
        } else {
            this.afficherPlateau();
            this.lancerMenu();
        }
    }

    public void recolter() {
        System.out.println("O\u00f9 voulez-vous recolter ?");
        Coordonnees c = this.saisirCoordonnees();
        if (c.getX() != -1 && c.getY() != -1) {
            this.jeu.recolter(c);
        } else {
            this.afficherPlateau();
            this.lancerMenu();
        }
    }

    public void irriguer() {
        System.out.println("O\u00f9 voulez-vous irriguer ?");
        Coordonnees c = this.saisirCoordonnees();
        int x = c.getX();
        int y = c.getY();
        if (x != -1 && y != -1) {
            this.jeu.irriguer(c);
        } else {
            this.afficherPlateau();
            this.lancerMenu();
        }
    }

    public void defricher() {
        System.out.println("O\u00f9 voulez-vous defricher ?");
        Coordonnees c = this.saisirCoordonnees();
        if (c.getX() != -1 && c.getY() != -1) {
            this.jeu.defricher(c);
        } else {
            this.afficherPlateau();
            this.lancerMenu();
        }
    }

    public void afficherLegende() {
        System.out.println("))) eau ; @@@ rocher ; . cultivable ; _ en friche\nRa : radis ; T : tomate ; Ri : riz");
        this.saisirString();
        this.afficherPlateau();
        this.lancerMenu();
    }

    public void passerTour() {
        this.jeu.calculerBesoinManger();
        if (this.jeu.getBesoinManger() == 0) {
            System.out.println("Il vous reste " + (3 - this.jeu.getNbTour()) + " tour(s) sans avoir besoin de manger !");
            this.saisirString();
        }
        if (this.jeu.getBesoinManger() > 0) {
            String nom = "";
            boolean aMange = false;
            Mangeable m = null;
            System.out.println("Vous devez manger " + this.jeu.getBesoinManger() + " l\u00e9gume(s).");
            for (int i = 0; i < this.jeu.getBesoinManger(); ++i) {
                do {
                    System.out.println("Que voulez-vous manger ?");
                    nom = this.saisirString();
                    nom = nom.toLowerCase();
                    aMange = false;
                    if (nom.equals("tomate")) {
                        m = new Tomate();
                        aMange = true;
                    } else if (nom.equals("radis")) {
                        m = new Radis();
                        aMange = true;
                    } else if (nom.equals("riz")) {
                        m = new Riz();
                        aMange = true;
                    }
                    if (!aMange) continue;
                    this.jeu.manger(m);
                } while (!aMange);
            }
        }
        if (this.jeu.getBesoinManger() != -1) {
            this.jeu.passerTour();
        }
    }

    public Coordonnees saisirCoordonnees() {
        int y;
        int x;
        Scanner sc = new Scanner(System.in);
        do {
            System.out.print("Colonne : ");
            x = sc.nextInt() - 1;
            System.out.print("Ligne : ");
            y = sc.nextInt() - 1;
            if (x >= -1 && x <= 7 && y >= -1 && y <= 7) continue;
            System.out.println("Mauvaises coordonn\u00e9es!");
        } while (x < -1 || x > 7 || y < -1 || y > 7);
        return new Coordonnees(x, y);
    }

    private String saisirString() {
        Scanner sc = new Scanner(System.in);
        return sc.nextLine();
    }
}

