/*
 * Decompiled with CFR 0.152.
 */
package vue.swing;

import configuration.Parametres;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import modele.jeu.Jeu;
import modele.terrain.GenererTerrain;
import modele.terrain.Terrain;
import vue.console.AfficheurConsole;
import vue.swing.AfficheurTerrain;
import vue.swing.BoutonMenu;
import vue.swing.PanelBackground;
import vue.swing.PanelMenu;

public class AfficheurStart
extends JFrame {
    private JPanel panelBackground = new PanelBackground();
    private JPanel panelMenu = new JPanel();
    private JPanel panelNiveau;
    private PanelMenu panelCredits;
    private PanelMenu panelAide;
    private PanelMenu panelAide2;
    private PanelMenu panelAide3;
    private BoutonMenu lancerJeu;
    private BoutonMenu aide;
    private BoutonMenu credits;
    private BoutonMenu quitter;
    private Terrain terrain;
    private Jeu jeu;
    private int mode;

    public AfficheurStart(int choixMode) {
        this.mode = choixMode;
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.7f);
        this.panelMenu.setBackground(color);
        this.panelMenu.setPreferredSize(new Dimension(300, 250));
        this.panelMenu.setLayout(new GridLayout(4, 1, 0, 0));
        this.lancerJeu = new BoutonMenu("Jouer");
        this.aide = new BoutonMenu("Aide");
        this.credits = new BoutonMenu("Cr\u00e9dits");
        this.quitter = new BoutonMenu("Quitter");
        Font font = new Font("Dialog", 1, 22);
        this.lancerJeu.setFont(font);
        this.aide.setFont(font);
        this.credits.setFont(font);
        this.quitter.setFont(font);
        JPanel panelStart = new JPanel();
        JPanel panelBoutonAide = new JPanel();
        JPanel panelBoutonCredits = new JPanel();
        JPanel panelQuit = new JPanel();
        panelStart.setOpaque(false);
        panelBoutonAide.setOpaque(false);
        panelBoutonCredits.setOpaque(false);
        panelQuit.setOpaque(false);
        panelStart.add(this.lancerJeu);
        panelBoutonAide.add(this.aide);
        panelBoutonCredits.add(this.credits);
        panelQuit.add(this.quitter);
        this.panelMenu.add(panelStart);
        this.panelMenu.add(panelBoutonAide);
        this.panelMenu.add(panelBoutonCredits);
        this.panelMenu.add(panelQuit);
        this.lancerJeu.addActionListener(new EcouteurBoutonLancer());
        this.aide.addActionListener(new EcouteurBoutonAide());
        this.credits.addActionListener(new EcouteurBoutonCredit());
        this.quitter.addActionListener(new EcouteurBoutonQuit());
        this.setContentPane(this.panelBackground);
        this.getContentPane().setLayout(null);
        this.add(this.panelMenu);
        this.creerPanelCredits();
        this.creerPanelAide();
        this.creerPanelAide2();
        this.creerPanelAide3();
        this.creerPanelNiveau();
        Dimension size = this.panelMenu.getPreferredSize();
        this.panelMenu.setBounds(500 + this.getInsets().left, 180 + this.getInsets().top, size.width, size.height);
        this.setTitle("Survival Potager");
        this.setSize(1024, 512);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private void creerPanelCredits() {
        this.panelCredits = new PanelMenu("<html><h2>Cr\u00e9dits</h2>Survival Potager est un projet de fin d'ann\u00e9e r\u00e9alis\u00e9 par Cyril Ly et <br>Dimitri S\u00e9gard \u00e9tudiants en premi\u00e8re ann\u00e9e de DUT Informatique <br>\u00e0 l'IUT de Montreuil.<br><br>Nous tenons \u00e0 remercier plus particuli\u00e8rement nos professeurs <br>Marianne Simonot et Thomas Bottini qui nous ont suivi et guid\u00e9 tout <br>au long de ce projet ainsi que Alexandre Diboine qui a r\u00e9alis\u00e9<br> les graphismes du jeu.</html>");
        BoutonMenu menu = new BoutonMenu("Menu");
        menu.addActionListener(new EcouteurBoutonClose());
        this.panelCredits.ajouterBouton(menu);
        this.add(this.panelCredits);
    }

    private void creerPanelAide() {
        this.panelAide = new PanelMenu("<html><h2>Aide</h2><h3>Pr\u00e9sentation du jeu</h3>Vous \u00eates un agriculteur de haut rang et vous avez \u00e9chou\u00e9 sur une \u00eele d\u00e9serte <br>suite \u00e0 une croisi\u00e8re en bateau. Vous devez survivre le temps que les <br>secouristes viennent vous sauver. Pour cela vous poss\u00e9dez une caissette <br>de l\u00e9gumes que vous devez cultiver afin de survivre.<br><br>Le jeu se termine lorsque vous avez \u00e9t\u00e9 secouru ou lorsque vous n'avez <br>plus de quoi manger.</html>");
        BoutonMenu menu = new BoutonMenu("Menu");
        BoutonMenu suivant = new BoutonMenu("Suivant");
        menu.addActionListener(new EcouteurBoutonClose());
        suivant.addActionListener(new EcouteurBoutonNext());
        this.panelAide.ajouterBouton(menu);
        this.panelAide.ajouterBouton(suivant);
        this.add(this.panelAide);
    }

    private void creerPanelAide2() {
        this.panelAide2 = new PanelMenu("<html><h2>Aide</h2><h3>Le terrain</h3>L'\u00eele est compos\u00e9e de plusieurs parcelles, qui sont :<br>&bull; des rochers : obstacles inamovibles g\u00eanant votre d\u00e9veloppement <br>&bull; de la terre cultivable, sur lesquelles vous pourrez planter les ressources <br>&bull; de la terre potentiellement cultivables mais en friche, qu'il vous faudra <br>d\u00e9fricher pour pouvoir y planter quelque chose <br>&bull; de l'eau, repr\u00e9sentant la rivi\u00e8re qui coule sur l'\u00eele et qui apporte <br>l'eau n\u00e9cessaire \u00e0 vos cultures.</html>");
        BoutonMenu menu = new BoutonMenu("Menu");
        BoutonMenu suivant = new BoutonMenu("Suivant");
        BoutonMenu precedent = new BoutonMenu("Pr\u00e9c\u00e9dent");
        menu.addActionListener(new EcouteurBoutonClose());
        suivant.addActionListener(new EcouteurBoutonNext());
        precedent.addActionListener(new EcouteurBoutonPrevious());
        this.panelAide2.ajouterBouton(precedent);
        this.panelAide2.ajouterBouton(menu);
        this.panelAide2.ajouterBouton(suivant);
        this.add(this.panelAide2);
    }

    private void creerPanelAide3() {
        this.panelAide3 = new PanelMenu("<html><h2>Aide</h2><h3>Actions</h3>Planter : pour planter quelque chose sur une parcelle, celle-ci doit \u00eatre <br>cultivable/d\u00e9frich\u00e9e, et non occup\u00e9e par une culture.<br>Defricher : la parcelle en friche devient une parcelle cultivable.<br> Irriguer : il est possible d'irriguer une parcelle cultivable (en friche ou non),<br> ce qui a pour effet d'y d\u00e9truire la culture qui y existait \u00e9ventuellement. <br>Recolter : une fois arriv\u00e9e \u00e0 maturit\u00e9, une ressource cultiv\u00e9e doit \u00eatre r\u00e9colt\u00e9e,<br> sinon elle dispara\u00eet au tour d'apr\u00e8s<br></html>");
        BoutonMenu menu = new BoutonMenu("Menu");
        BoutonMenu precedent = new BoutonMenu("Pr\u00e9c\u00e9dent");
        menu.addActionListener(new EcouteurBoutonClose());
        precedent.addActionListener(new EcouteurBoutonPrevious());
        this.panelAide3.ajouterBouton(precedent);
        this.panelAide3.ajouterBouton(menu);
        this.add(this.panelAide3);
    }

    public void creerPanelNiveau() {
        this.panelNiveau = new JPanel();
        BoutonMenu easy = new BoutonMenu("Facile");
        BoutonMenu medium = new BoutonMenu("Moyen");
        BoutonMenu hard = new BoutonMenu("Difficile");
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.7f);
        this.panelNiveau.setBackground(color);
        this.panelNiveau.setLayout(new GridLayout(3, 1, 0, 0));
        this.panelNiveau.setPreferredSize(new Dimension(300, 250));
        Dimension size = this.panelNiveau.getPreferredSize();
        this.panelNiveau.setBounds(500 + this.getInsets().left, 180 + this.getInsets().top, size.width, size.height);
        easy.addActionListener(new EcouteurBoutonEasy());
        medium.addActionListener(new EcouteurBoutonMedium());
        hard.addActionListener(new EcouteurBoutonHard());
        this.panelNiveau.add(easy);
        this.panelNiveau.add(medium);
        this.panelNiveau.add(hard);
        this.panelNiveau.setVisible(false);
        this.add(this.panelNiveau);
    }

    private class EcouteurBoutonHard
    implements ActionListener {
        private EcouteurBoutonHard() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.dispose();
            int difficulte = 3;
            Parametres p = new Parametres(difficulte);
            AfficheurStart.this.terrain = new Terrain(7, 7);
            GenererTerrain t = new GenererTerrain(AfficheurStart.this.terrain);
            t.aleatoire();
            AfficheurStart.this.jeu = new Jeu(AfficheurStart.this.terrain, p);
            if (AfficheurStart.this.mode == 1) {
                AfficheurTerrain afficheurTerrain = new AfficheurTerrain(AfficheurStart.this.terrain, AfficheurStart.this.jeu);
            } else if (AfficheurStart.this.mode == 0) {
                AfficheurConsole afficheurConsole = new AfficheurConsole(AfficheurStart.this.terrain, AfficheurStart.this.jeu);
                AfficheurStart.this.jeu.lancer();
            }
        }
    }

    private class EcouteurBoutonMedium
    implements ActionListener {
        private EcouteurBoutonMedium() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.dispose();
            int difficulte = 2;
            Parametres p = new Parametres(difficulte);
            AfficheurStart.this.terrain = new Terrain(7, 7);
            GenererTerrain t = new GenererTerrain(AfficheurStart.this.terrain);
            t.aleatoire();
            AfficheurStart.this.jeu = new Jeu(AfficheurStart.this.terrain, p);
            if (AfficheurStart.this.mode == 1) {
                AfficheurTerrain afficheurTerrain = new AfficheurTerrain(AfficheurStart.this.terrain, AfficheurStart.this.jeu);
            } else if (AfficheurStart.this.mode == 0) {
                AfficheurConsole afficheurConsole = new AfficheurConsole(AfficheurStart.this.terrain, AfficheurStart.this.jeu);
                AfficheurStart.this.jeu.lancer();
            }
        }
    }

    private class EcouteurBoutonEasy
    implements ActionListener {
        private EcouteurBoutonEasy() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.dispose();
            int difficulte = 1;
            Parametres p = new Parametres(difficulte);
            AfficheurStart.this.terrain = new Terrain(7, 7);
            GenererTerrain t = new GenererTerrain(AfficheurStart.this.terrain);
            t.aleatoire();
            AfficheurStart.this.jeu = new Jeu(AfficheurStart.this.terrain, p);
            if (AfficheurStart.this.mode == 1) {
                AfficheurTerrain afficheurTerrain = new AfficheurTerrain(AfficheurStart.this.terrain, AfficheurStart.this.jeu);
            } else if (AfficheurStart.this.mode == 0) {
                AfficheurConsole afficheurConseul = new AfficheurConsole(AfficheurStart.this.terrain, AfficheurStart.this.jeu);
                AfficheurStart.this.jeu.lancer();
            }
        }
    }

    private class EcouteurBoutonPrevious
    implements ActionListener {
        private EcouteurBoutonPrevious() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AfficheurStart.this.panelAide2.isVisible()) {
                AfficheurStart.this.panelAide2.setVisible(false);
                AfficheurStart.this.repaint();
                AfficheurStart.this.panelAide.setVisible(true);
            }
            if (AfficheurStart.this.panelAide3.isVisible()) {
                AfficheurStart.this.panelAide3.setVisible(false);
                AfficheurStart.this.repaint();
                AfficheurStart.this.panelAide2.setVisible(true);
            }
        }
    }

    private class EcouteurBoutonNext
    implements ActionListener {
        private EcouteurBoutonNext() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AfficheurStart.this.panelAide.isVisible()) {
                AfficheurStart.this.panelAide.setVisible(false);
                AfficheurStart.this.repaint();
                AfficheurStart.this.panelAide2.setVisible(true);
            } else if (AfficheurStart.this.panelAide2.isVisible()) {
                AfficheurStart.this.panelAide2.setVisible(false);
                AfficheurStart.this.repaint();
                AfficheurStart.this.panelAide3.setVisible(true);
            }
        }
    }

    private class EcouteurBoutonQuit
    implements ActionListener {
        private EcouteurBoutonQuit() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.dispose();
        }
    }

    private class EcouteurBoutonClose
    implements ActionListener {
        private EcouteurBoutonClose() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.panelCredits.setVisible(false);
            AfficheurStart.this.panelAide.setVisible(false);
            AfficheurStart.this.panelAide2.setVisible(false);
            AfficheurStart.this.panelAide3.setVisible(false);
            AfficheurStart.this.add(AfficheurStart.this.panelMenu);
            AfficheurStart.this.repaint();
        }
    }

    private class EcouteurBoutonCredit
    implements ActionListener {
        private EcouteurBoutonCredit() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.getContentPane().remove(AfficheurStart.this.panelMenu);
            AfficheurStart.this.repaint();
            AfficheurStart.this.panelCredits.setVisible(true);
        }
    }

    private class EcouteurBoutonAide
    implements ActionListener {
        private EcouteurBoutonAide() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.getContentPane().remove(AfficheurStart.this.panelMenu);
            AfficheurStart.this.repaint();
            AfficheurStart.this.panelAide.setVisible(true);
        }
    }

    private class EcouteurBoutonLancer
    implements ActionListener {
        private EcouteurBoutonLancer() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurStart.this.getContentPane().remove(AfficheurStart.this.panelMenu);
            AfficheurStart.this.repaint();
            AfficheurStart.this.panelNiveau.setVisible(true);
        }
    }
}

