/*
 * Decompiled with CFR 0.152.
 */
package vue.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import modele.jeu.Jeu;
import modele.mangeables.Mangeable;
import modele.mangeables.Radis;
import modele.mangeables.Riz;
import modele.mangeables.Tomate;
import modele.terrain.ParcelleAbstraite;
import modele.terrain.ParcelleCultivable;
import modele.terrain.ParcelleEau;
import modele.terrain.ParcelleRocher;
import modele.terrain.Terrain;
import outils.Coordonnees;
import vue.swing.AfficheurStart;
import vue.swing.BoutonAction;
import vue.swing.BoutonParcelle;
import vue.swing.Sprites;

public class AfficheurTerrain
extends JFrame {
    private Terrain terrain;
    private Jeu jeu;
    private Sprites sprites;
    private JPanel panelTerrain;
    private JPanel panelDroite;
    private JPanel panelActionsBoutons;
    private JPanel panelActions;
    private JPanel panelPlanter;
    private JLabel labelInfoRessources;
    private JLabel labelInfoParcelle;
    private JLabel labelInfoMangeable;
    private BoutonAction boutonPlanter;
    private BoutonAction boutonRecolter;
    private BoutonAction boutonIrriguer;
    private BoutonAction boutonDefricher;
    private BoutonAction boutonPasserTour;
    private BoutonAction boutonMangerRadis;
    private BoutonAction boutonMangerTomate;
    private BoutonAction boutonMangerRiz;
    private Coordonnees coordonneesParcelleCible;
    private BoutonParcelle[][] listeDesBoutons;
    private JComboBox listePlanter;
    private String choixPlanter;
    private boolean planterClic;
    private JPanel panelInformations;
    private JPanel panelHaut;
    private JPanel panelBas;
    private int besoinManger;
    private JPanel panelManger;
    private JFrame fenetreFin;

    public AfficheurTerrain(Terrain terrain, Jeu jeu) {
        this.terrain = terrain;
        this.jeu = jeu;
        this.sprites = new Sprites("sprites.png");
        this.setTitle("Survival Potager");
        this.besoinManger = 0;
        JPanel panelPrincipal = new JPanel(new BorderLayout());
        this.add(panelPrincipal);
        this.creerPanelTerrain();
        this.creerPaneldroite();
        this.add((Component)this.panelTerrain, "Center");
        this.add((Component)this.panelDroite, "East");
        this.jeu.ajouterEcouteurParcelle(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                BoutonParcelle bouton;
                int y;
                int x;
                if (e.getPropertyName().equals("defricher") || e.getPropertyName().equals("recolter")) {
                    x = ((Coordonnees)e.getNewValue()).getX();
                    y = ((Coordonnees)e.getNewValue()).getY();
                    bouton = AfficheurTerrain.this.listeDesBoutons[y][x];
                    Random random = new Random();
                    int indice = random.nextInt(3) + 7;
                    bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(indice));
                    bouton.repaint();
                }
                if (e.getPropertyName().equals("planter")) {
                    x = ((Coordonnees)e.getNewValue()).getX();
                    y = ((Coordonnees)e.getNewValue()).getY();
                    bouton = AfficheurTerrain.this.listeDesBoutons[y][x];
                    bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(12));
                    bouton.repaint();
                }
                if (e.getPropertyName().equals("croitre")) {
                    x = ((Coordonnees)e.getNewValue()).getX();
                    y = ((Coordonnees)e.getNewValue()).getY();
                    bouton = AfficheurTerrain.this.listeDesBoutons[y][x];
                    ParcelleCultivable parcelleCultivable = (ParcelleCultivable)AfficheurTerrain.this.terrain.getParcelle(x, y);
                    if (parcelleCultivable.getMangeable() instanceof Radis) {
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() == 0) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(14));
                        }
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() == 1) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(13));
                        }
                    }
                    if (parcelleCultivable.getMangeable() instanceof Tomate) {
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() == 0) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(15));
                        }
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() == 1) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(13));
                        }
                    }
                    if (parcelleCultivable.getMangeable() instanceof Riz) {
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() == 0) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(16));
                        }
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() <= 5 && parcelleCultivable.getMangeable().getToursAvantCueillette() >= 3) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(12));
                        }
                        if (parcelleCultivable.getMangeable().getToursAvantCueillette() < 3 && parcelleCultivable.getMangeable().getToursAvantCueillette() > 0) {
                            bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(13));
                        }
                    }
                    if (parcelleCultivable.getMangeable() == null) {
                        Random random = new Random();
                        int indice = random.nextInt(3) + 7;
                        bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(indice));
                    }
                    bouton.repaint();
                }
                if (e.getPropertyName().equals("irriguer")) {
                    x = ((Coordonnees)e.getNewValue()).getX();
                    y = ((Coordonnees)e.getNewValue()).getY();
                    bouton = AfficheurTerrain.this.listeDesBoutons[y][x];
                    int indice = 0;
                    if (x - 1 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau) {
                        indice = 36;
                        BoutonParcelle gauche = AfficheurTerrain.this.listeDesBoutons[y][x - 1];
                        gauche.changeImage(AfficheurTerrain.this.sprites.getSprite(33));
                        gauche.repaint();
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau) {
                        indice = 37;
                        BoutonParcelle droite = AfficheurTerrain.this.listeDesBoutons[y][x + 1];
                        droite.changeImage(AfficheurTerrain.this.sprites.getSprite(34));
                        droite.repaint();
                    }
                    if (y - 1 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau) {
                        indice = 35;
                        BoutonParcelle droite = AfficheurTerrain.this.listeDesBoutons[y - 1][x];
                        droite.changeImage(AfficheurTerrain.this.sprites.getSprite(31));
                        droite.repaint();
                    }
                    if (y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau) {
                        indice = 38;
                        BoutonParcelle droite = AfficheurTerrain.this.listeDesBoutons[y + 1][x];
                        droite.changeImage(AfficheurTerrain.this.sprites.getSprite(32));
                        droite.repaint();
                    }
                    if (y - 1 >= 0 && y - 2 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y - 2) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y - 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(28));
                        haut.repaint();
                        indice = 35;
                    }
                    if (y + 1 < AfficheurTerrain.this.terrain.getTailleV() && y + 2 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 2) instanceof ParcelleEau) {
                        BoutonParcelle bas = AfficheurTerrain.this.listeDesBoutons[y + 1][x];
                        bas.changeImage(AfficheurTerrain.this.sprites.getSprite(28));
                        bas.repaint();
                        indice = 38;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && x + 2 < AfficheurTerrain.this.terrain.getTailleH() && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 2, y) instanceof ParcelleEau) {
                        BoutonParcelle droite = AfficheurTerrain.this.listeDesBoutons[y][x + 1];
                        droite.changeImage(AfficheurTerrain.this.sprites.getSprite(27));
                        droite.repaint();
                        indice = 37;
                    }
                    if (x - 1 >= 0 && x - 2 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x - 2, y) instanceof ParcelleEau) {
                        BoutonParcelle gauche = AfficheurTerrain.this.listeDesBoutons[y][x - 1];
                        gauche.changeImage(AfficheurTerrain.this.sprites.getSprite(27));
                        gauche.repaint();
                        indice = 36;
                    }
                    if (x - 1 >= 0 && y - 1 >= 0 && y - 2 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x - 1, y - 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y - 2) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y - 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(34));
                        haut.repaint();
                        indice = 35;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && y - 1 >= 0 && y - 2 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x + 1, y - 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y - 2) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y - 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(33));
                        haut.repaint();
                        indice = 35;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x + 1, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y + 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(29));
                        haut.repaint();
                        indice = 38;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && y + 2 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x + 1, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 2) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y + 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(33));
                        haut.repaint();
                        indice = 38;
                    }
                    if (x - 1 >= 0 && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x - 1, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y + 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(30));
                        haut.repaint();
                        indice = 38;
                    }
                    if (x - 1 >= 0 && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && y + 2 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x - 1, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 2) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y + 1][x];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(34));
                        haut.repaint();
                        indice = 38;
                    }
                    if (x - 1 >= 0 && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x - 1, y + 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x - 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(26));
                        haut.repaint();
                        indice = 36;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 1, y + 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x + 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(25));
                        haut.repaint();
                        indice = 37;
                    }
                    if (x - 1 >= 0 && x - 2 >= 0 && y - 1 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x - 2, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x - 1, y - 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x - 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(32));
                        haut.repaint();
                        indice = 36;
                    }
                    if (x - 1 >= 0 && x - 2 >= 0 && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x - 2, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x - 1, y + 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x - 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(31));
                        haut.repaint();
                        indice = 36;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && x + 2 < AfficheurTerrain.this.terrain.getTailleH() && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 2, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 1, y + 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x + 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(31));
                        haut.repaint();
                        indice = 37;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && y - 1 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 1, y - 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x + 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(30));
                        haut.repaint();
                        indice = 37;
                    }
                    if (x + 1 < AfficheurTerrain.this.terrain.getTailleH() && x + 2 < AfficheurTerrain.this.terrain.getTailleH() && y - 1 >= 0 && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 2, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 1, y - 1) instanceof ParcelleEau) {
                        BoutonParcelle haut = AfficheurTerrain.this.listeDesBoutons[y][x + 1];
                        haut.changeImage(AfficheurTerrain.this.sprites.getSprite(32));
                        haut.repaint();
                        indice = 37;
                    }
                    if (x - 1 >= 0 && y - 1 >= 0 && x + 1 < AfficheurTerrain.this.terrain.getTailleH() && y + 1 < AfficheurTerrain.this.terrain.getTailleV() && AfficheurTerrain.this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau && AfficheurTerrain.this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau) {
                        indice = 24;
                    }
                    bouton.changeImage(AfficheurTerrain.this.sprites.getSprite(indice));
                    bouton.repaint();
                }
                AfficheurTerrain.this.generateLabelInformation((Coordonnees)e.getNewValue());
            }
        });
        this.jeu.ajouterEcouteurRessources(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Color color = new Color(0.0f, 0.0f, 0.0f, 0.5f);
                AfficheurTerrain.this.labelInfoRessources.setText("<html><font color=\"white\"><font size=\"5\">Jour " + AfficheurTerrain.this.jeu.getNbTour() + "</font><br><br>Radis : " + AfficheurTerrain.this.jeu.getNombreRadis() + "<br>Tomate : " + AfficheurTerrain.this.jeu.getNombreTomates() + "<br>Riz : " + AfficheurTerrain.this.jeu.getNombreRiz() + "<br><br>PA : " + AfficheurTerrain.this.jeu.getPA() + "</font></html>");
                AfficheurTerrain.this.labelInfoRessources.setOpaque(true);
                AfficheurTerrain.this.labelInfoRessources.setBackground(color);
                AfficheurTerrain.this.labelInfoRessources.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                AfficheurTerrain.this.labelInfoRessources.setPreferredSize(new Dimension(200, 150));
                if (AfficheurTerrain.this.coordonneesParcelleCible != null) {
                    AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
                }
                AfficheurTerrain.this.panelDroite.repaint();
                if (AfficheurTerrain.this.jeu.getFini()) {
                    if (AfficheurTerrain.this.jeu.getGagner()) {
                        System.out.println("F\u00e9licitations, vous avez gagn\u00e9 !");
                        AfficheurTerrain.this.creerFenetreFin("F\u00e9licitation, vous avez gagn\u00e9 !");
                    } else if (!AfficheurTerrain.this.jeu.getGagner()) {
                        System.out.println("Malheureusement, vous avez perdu...");
                        AfficheurTerrain.this.creerFenetreFin("Malheureusement, vous avez perdu !");
                    }
                } else if (AfficheurTerrain.this.jeu.getPA() == 0) {
                    AfficheurTerrain.this.passerTour();
                }
            }
        });
        this.setSize(950, 700);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void creerRenduTerrain() {
        int j;
        int i;
        this.listeDesBoutons = new BoutonParcelle[7][7];
        boolean n = false;
        int indice = 0;
        Random random = new Random();
        for (i = 0; i < this.terrain.getTailleH(); ++i) {
            for (j = 0; j < this.terrain.getTailleV(); ++j) {
                if (this.terrain.getParcelle(j, i) instanceof ParcelleCultivable) {
                    if (this.terrain.getParcelle(j, i).getEtat()) {
                        indice = random.nextInt(4);
                    } else if (((ParcelleCultivable)this.terrain.getParcelle(j, i)).getMangeable() == null) {
                        indice = random.nextInt(3) + 7;
                    }
                }
                if (this.terrain.getParcelle(j, i) instanceof ParcelleEau) {
                    indice = 24;
                    if (j == 0 && this.terrain.getParcelle(j + 1, i) instanceof ParcelleEau || j - 1 >= 0 && this.terrain.getParcelle(j - 1, i) instanceof ParcelleEau && this.terrain.getParcelle(j - 1, i) instanceof ParcelleEau || j - 1 >= 0 && j == this.terrain.getTailleH() && this.terrain.getParcelle(j - 1, i) instanceof ParcelleEau) {
                        indice = 27;
                    }
                    if (i == 0 && this.terrain.getParcelle(j, i + 1) instanceof ParcelleEau || i - 1 >= 0 && this.terrain.getParcelle(j, i - 1) instanceof ParcelleEau && this.terrain.getParcelle(j, i - 1) instanceof ParcelleEau || i - 1 >= 0 && i == this.terrain.getTailleH() - 1 && this.terrain.getParcelle(j, i - 1) instanceof ParcelleEau) {
                        indice = 28;
                    }
                    if (j - 1 >= 0 && i - 1 >= 0 && this.terrain.getParcelle(j - 1, i) instanceof ParcelleEau && this.terrain.getParcelle(j, i - 1) instanceof ParcelleEau) {
                        indice = 30;
                    }
                    if (i - 1 >= 0 && j + 1 < this.terrain.getTailleH() && this.terrain.getParcelle(j + 1, i) instanceof ParcelleEau && this.terrain.getParcelle(j, i - 1) instanceof ParcelleEau) {
                        indice = 29;
                    }
                    if (i + 1 < this.terrain.getTailleV() && j + 1 < this.terrain.getTailleH() && this.terrain.getParcelle(j + 1, i) instanceof ParcelleEau && this.terrain.getParcelle(j, i + 1) instanceof ParcelleEau) {
                        indice = 26;
                    }
                    if (j - 1 >= 0 && j + 1 < this.terrain.getTailleH() && i + 1 < this.terrain.getTailleV() && this.terrain.getParcelle(j - 1, i) instanceof ParcelleEau && this.terrain.getParcelle(j, i + 1) instanceof ParcelleEau || i + 1 < this.terrain.getTailleV() && j == this.terrain.getTailleH() - 1 && this.terrain.getParcelle(j - 1, i) instanceof ParcelleEau && this.terrain.getParcelle(j, i + 1) instanceof ParcelleEau) {
                        indice = 25;
                    }
                }
                if (this.terrain.getParcelle(j, i) instanceof ParcelleRocher) {
                    indice = random.nextInt(3) + 21;
                }
                this.listeDesBoutons[i][j] = new BoutonParcelle("", this.sprites.getSprite(indice), new Coordonnees(j, i));
            }
        }
        for (i = 0; i < this.listeDesBoutons.length; ++i) {
            for (j = 0; j < this.listeDesBoutons[i].length; ++j) {
                this.panelTerrain.add(this.listeDesBoutons[i][j]);
                this.listeDesBoutons[i][j].setFocusPainted(true);
                this.listeDesBoutons[i][j].setMargin(null);
                this.listeDesBoutons[i][j].setBorder(BorderFactory.createEmptyBorder());
                this.listeDesBoutons[i][j].setContentAreaFilled(false);
                this.listeDesBoutons[i][j].addActionListener(new EcouteurBoutonParcelle());
            }
        }
    }

    private void creerPanelTerrain() {
        this.panelTerrain = new JPanel(new GridLayout(7, 7, 0, 0));
        this.panelTerrain.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.creerRenduTerrain();
    }

    private void creerPaneldroite() {
        this.panelDroite = new JPanel(new GridLayout(2, 1, 0, 0));
        this.panelDroite.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.panelDroite.setBackground(Color.DARK_GRAY);
        this.panelHaut = this.creerPanelHautDroite();
        this.panelBas = this.creerPanelBasDroite();
        this.panelDroite.add(this.panelHaut);
        this.panelDroite.add(this.panelBas);
    }

    private JPanel creerPanelHautDroite() {
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridLayout(2, 1, 0, 0));
        panel.setBackground(Color.DARK_GRAY);
        JPanel panelRessources = new JPanel();
        panelRessources.setBorder(BorderFactory.createEmptyBorder());
        panelRessources.setBackground(Color.DARK_GRAY);
        JPanel panelPasserTour = new JPanel();
        panelPasserTour.setBorder(BorderFactory.createEmptyBorder());
        panelPasserTour.setBackground(Color.DARK_GRAY);
        this.labelInfoRessources = new JLabel("<html><font color=\"white\"><font size=\"5\">Jour " + this.jeu.getNbTour() + "</font><br><br>Radis : " + this.jeu.getNombreRadis() + "<br>Tomate : " + this.jeu.getNombreTomates() + "<br>Riz : " + this.jeu.getNombreRiz() + "<br><br>PA : " + this.jeu.getPA() + "</font></html>");
        this.labelInfoRessources.setOpaque(true);
        this.labelInfoRessources.setBackground(color);
        this.labelInfoRessources.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelInfoRessources.setPreferredSize(new Dimension(200, 150));
        panelRessources.add(this.labelInfoRessources);
        panel.add(panelRessources);
        this.boutonPasserTour = new BoutonAction("Passer au jour suivant");
        this.boutonPasserTour.addActionListener(new EcouteurBoutonPasserTour());
        panelPasserTour.add(this.boutonPasserTour);
        panel.add(panelPasserTour);
        return panel;
    }

    private JPanel creerPanelBasDroite() {
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridLayout(2, 1, 0, 0));
        panel.setBackground(Color.DARK_GRAY);
        this.panelInformations = new JPanel();
        this.panelInformations.setBorder(BorderFactory.createEmptyBorder());
        this.panelInformations.setBackground(Color.DARK_GRAY);
        this.panelActions = new JPanel();
        this.panelActions.setBorder(BorderFactory.createEmptyBorder());
        this.panelActions.setBackground(Color.DARK_GRAY);
        this.panelActionsBoutons = new JPanel();
        this.panelActionsBoutons.setBorder(BorderFactory.createEmptyBorder());
        this.panelActionsBoutons.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.panelManger = new JPanel();
        this.panelManger.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.panelManger.setLayout(new GridLayout(3, 1, 1, 1));
        this.boutonMangerRadis = new BoutonAction("Radis");
        this.boutonMangerRadis.addActionListener(new EcouteurBoutonMangerRadis());
        this.boutonMangerTomate = new BoutonAction("Tomate");
        this.boutonMangerTomate.addActionListener(new EcouteurBoutonMangerTomate());
        this.boutonMangerRiz = new BoutonAction("Riz");
        this.boutonMangerRiz.addActionListener(new EcouteurBoutonMangerRiz());
        this.panelPlanter = new JPanel();
        this.panelPlanter.setBorder(BorderFactory.createEmptyBorder());
        this.panelPlanter.setPreferredSize(new Dimension(200, 200));
        this.panelPlanter.setOpaque(true);
        this.panelPlanter.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.panelPlanter.setVisible(false);
        this.listePlanter = new JComboBox();
        this.listePlanter.setMaximumRowCount(4);
        this.listePlanter.setForeground(Color.WHITE);
        this.listePlanter.setBackground(Color.DARK_GRAY);
        this.listePlanter.setPreferredSize(new Dimension(120, 20));
        this.listePlanter.addItem("Votre choix ?");
        this.listePlanter.addItemListener(new ItemState());
        this.panelPlanter.add(this.listePlanter);
        JButton planterValider = new JButton("Valider");
        planterValider.setBackground(Color.DARK_GRAY);
        planterValider.setForeground(Color.WHITE);
        planterValider.setFocusPainted(false);
        planterValider.setBorderPainted(false);
        planterValider.addActionListener(new EcouteurBoutonPlanterValider());
        this.panelPlanter.add(planterValider);
        this.labelInfoMangeable = new JLabel(" ");
        JPanel panelInfoMangeable = new JPanel();
        panelInfoMangeable.add(this.labelInfoMangeable);
        panelInfoMangeable.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.panelPlanter.add(panelInfoMangeable);
        this.panelActions.add(this.panelPlanter);
        this.labelInfoParcelle = new JLabel("");
        this.labelInfoParcelle.setOpaque(false);
        this.labelInfoParcelle.setBackground(color);
        this.labelInfoParcelle.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelInfoParcelle.setPreferredSize(new Dimension(200, 150));
        this.panelInformations.add(this.labelInfoParcelle);
        panel.add(this.panelInformations);
        this.panelActionsBoutons.setLayout(new GridLayout(4, 1, 0, 0));
        this.panelActionsBoutons.setOpaque(false);
        this.panelActionsBoutons.setBackground(color);
        this.panelActionsBoutons.setPreferredSize(new Dimension(200, 150));
        this.boutonPlanter = new BoutonAction("Planter");
        this.boutonPlanter.addActionListener(new EcouteurBoutonPlanter());
        this.boutonRecolter = new BoutonAction("R\u00e9colter");
        this.boutonRecolter.addActionListener(new EcouteurBoutonRecolter());
        this.boutonIrriguer = new BoutonAction("Irriguer");
        this.boutonIrriguer.addActionListener(new EcouteurBoutonIrriguer());
        this.boutonDefricher = new BoutonAction("D\u00e9fricher");
        this.boutonDefricher.addActionListener(new EcouteurBoutonDefricher());
        this.panelActions.add(this.panelActionsBoutons);
        panel.add(this.panelActions);
        return panel;
    }

    private void generateLabelInformation(Coordonnees c) {
        Dimension dimension = new Dimension(200, 150);
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        String texte = "<html><font color=\"white\"><font size=\"5\">Parcelle</font><br><br>Type : " + this.typeParcelle(this.terrain.getParcelle(c)) + "<br>";
        if (this.terrain.getParcelle(c) instanceof ParcelleCultivable && ((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable() != null) {
            texte = texte + "L\u00e9gume : " + this.typeMangeable(((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable()) + "<br>";
            texte = ((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable().getToursAvantCueillette() > 0 ? texte + "R\u00e9coltable dans " + ((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable().getToursAvantCueillette() + " jour(s)<br>" : texte + "Vous pouvez r\u00e9colter !<br>";
        }
        texte = texte + "<br>Colonne : " + (c.getX() + 1) + "<br>" + "Ligne : " + (c.getY() + 1) + "</font></html>";
        this.labelInfoParcelle.setText(texte);
        this.labelInfoParcelle.setOpaque(true);
        this.labelInfoParcelle.setBackground(color);
        this.labelInfoParcelle.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelInfoParcelle.setPreferredSize(dimension);
        this.panelDroite.repaint();
    }

    private void generateBoutonsActions(Coordonnees c) {
        int x = c.getX();
        int y = c.getY();
        int nb = 0;
        if (this.planterClic) {
            this.panelActions.remove(this.panelActionsBoutons);
            this.panelPlanter.setVisible(true);
            if (this.listePlanter.getItemCount() > 1) {
                int max = this.listePlanter.getItemCount();
                for (int i = 1; i < max; ++i) {
                    this.listePlanter.removeItemAt(1);
                }
                this.listePlanter.revalidate();
            }
            if (this.jeu.getNombreRadis() > 0 && this.terrain.calculerNombreDeParcellesAdjacentes(c, new ParcelleEau()) >= new Radis().getBesoinIrrigation()) {
                this.listePlanter.addItem("Radis");
            }
            if (this.jeu.getNombreTomates() > 0 && this.terrain.calculerNombreDeParcellesAdjacentes(c, new ParcelleEau()) >= new Tomate().getBesoinIrrigation()) {
                this.listePlanter.addItem("Tomate");
            }
            if (this.jeu.getNombreRiz() > 0 && this.terrain.calculerNombreDeParcellesAdjacentes(c, new ParcelleEau()) >= new Riz().getBesoinIrrigation()) {
                this.listePlanter.addItem("Riz");
            }
            this.panelActions.repaint();
            this.planterClic = false;
            ++nb;
        } else {
            this.panelPlanter.setVisible(false);
            this.panelActions.repaint();
            this.panelActionsBoutons.setOpaque(true);
            this.panelActionsBoutons.removeAll();
            this.panelActionsBoutons.repaint();
            this.panelActionsBoutons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.panelActionsBoutons.setLayout(new GridLayout(1, 1, 1, 1));
            this.panelActions.add(this.panelActionsBoutons);
            if (this.terrain.getParcelle(c) instanceof ParcelleCultivable && !((ParcelleCultivable)this.terrain.getParcelle(c)).getEtat() && ((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable() == null && (x + 1 < this.terrain.getTailleH() && this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau || x - 1 >= 0 && this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau || y + 1 < this.terrain.getTailleV() && this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau || y - 1 >= 0 && this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau)) {
                this.panelActionsBoutons.add(this.boutonPlanter);
                ++nb;
            }
            if (this.terrain.getParcelle(c) instanceof ParcelleCultivable && !((ParcelleCultivable)this.terrain.getParcelle(c)).getEtat() && ((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable() != null && ((ParcelleCultivable)this.terrain.getParcelle(c)).getMangeable().getToursAvantCueillette() == 0) {
                this.panelActionsBoutons.add(this.boutonRecolter);
                ++nb;
            }
            if (this.terrain.getParcelle(c) instanceof ParcelleCultivable && ((ParcelleCultivable)this.terrain.getParcelle(c)).getEtat()) {
                this.panelActionsBoutons.add(this.boutonDefricher);
                ++nb;
            }
            if (this.terrain.getParcelle(c) instanceof ParcelleCultivable && (x + 1 < this.terrain.getTailleH() && this.terrain.getParcelle(x + 1, y) instanceof ParcelleEau || x - 1 >= 0 && this.terrain.getParcelle(x - 1, y) instanceof ParcelleEau || y + 1 < this.terrain.getTailleV() && this.terrain.getParcelle(x, y + 1) instanceof ParcelleEau || y - 1 >= 0 && this.terrain.getParcelle(x, y - 1) instanceof ParcelleEau)) {
                this.panelActionsBoutons.add(this.boutonIrriguer);
                ++nb;
            }
        }
        if (nb == 0) {
            this.panelActionsBoutons.add(new JLabel("<html><font color=\"white\">Aucune action possible.</font></html>"));
            this.panelActionsBoutons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelActionsBoutons.repaint();
        } else {
            this.panelActionsBoutons.setLayout(new GridLayout(nb, 1, 1, 1));
            this.panelActionsBoutons.repaint();
        }
    }

    private void passerTour() {
        this.jeu.calculerBesoinManger();
        this.besoinManger = this.jeu.getBesoinManger();
        if (this.besoinManger == 0) {
            this.jeu.passerTour();
        }
        if (this.besoinManger > 0) {
            this.boutonPasserTour.setVisible(false);
            this.panelPlanter.setVisible(false);
            this.labelInfoParcelle.setVisible(false);
            this.panelActionsBoutons.setVisible(false);
            this.panelInformations.repaint();
            this.panelDroite.revalidate();
            this.panelManger.removeAll();
            this.panelManger.repaint();
            if (this.jeu.getNombreRadis() > 0) {
                this.panelManger.add(this.boutonMangerRadis);
            }
            if (this.jeu.getNombreTomates() > 0) {
                this.panelManger.add(this.boutonMangerTomate);
            }
            if (this.jeu.getNombreRiz() > 0) {
                this.panelManger.add(this.boutonMangerRiz);
            }
            this.panelInformations.add(this.panelManger);
        }
    }

    private String typeParcelle(ParcelleAbstraite p) {
        String nom = "";
        if (p instanceof ParcelleEau) {
            nom = "eau";
        }
        if (p instanceof ParcelleRocher) {
            nom = "rocher";
        }
        if (p instanceof ParcelleCultivable) {
            nom = p.getEtat() ? "terre en friche" : "terre cultivable";
        }
        return nom;
    }

    private String typeMangeable(Mangeable m) {
        String nom = "";
        if (m instanceof Radis) {
            nom = "radis";
        }
        if (m instanceof Tomate) {
            nom = "tomate";
        }
        if (m instanceof Riz) {
            nom = "riz";
        }
        return nom;
    }

    private Mangeable typeMangeable(String nom) {
        Mangeable m = null;
        if (nom.equals("radis")) {
            m = new Radis();
        }
        if (nom.equals("tomate")) {
            m = new Tomate();
        }
        if (nom.equals("riz")) {
            m = new Riz();
        }
        return m;
    }

    private void creerFenetreFin(String t) {
        this.fenetreFin = new JFrame("Fin de partie");
        JPanel panel = new JPanel();
        panel.setBackground(Color.DARK_GRAY);
        panel.setForeground(Color.WHITE);
        JPanel panelBoutons = new JPanel();
        JLabel message = new JLabel();
        BoutonAction retour = new BoutonAction("Retour au menu");
        BoutonAction quitter = new BoutonAction("Quitter");
        retour.addActionListener(new EcouteurBoutonRetour());
        quitter.addActionListener(new EcouteurBoutonQuitter());
        panelBoutons.setLayout(new GridLayout(1, 2, 0, 0));
        panelBoutons.add(retour);
        panelBoutons.add(quitter);
        message.setText(t);
        message.setForeground(Color.WHITE);
        panel.setLayout(new GridLayout(2, 1, 0, 0));
        panel.add(message);
        panel.add(panelBoutons);
        this.fenetreFin.add(panel);
        this.fenetreFin.setSize(400, 150);
        this.fenetreFin.setResizable(false);
        this.fenetreFin.setLocationRelativeTo(null);
        this.fenetreFin.setVisible(true);
        this.boutonPasserTour.setVisible(false);
    }

    private class EcouteurBoutonQuitter
    implements ActionListener {
        private EcouteurBoutonQuitter() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    private class EcouteurBoutonRetour
    implements ActionListener {
        private EcouteurBoutonRetour() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.setVisible(false);
            AfficheurTerrain.this.fenetreFin.dispose();
            AfficheurStart affStart = new AfficheurStart(1);
        }
    }

    private class EcouteurBoutonPasserTour
    implements ActionListener {
        private EcouteurBoutonPasserTour() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.passerTour();
        }
    }

    private class EcouteurBoutonDefricher
    implements ActionListener {
        private EcouteurBoutonDefricher() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.jeu.defricher(AfficheurTerrain.this.coordonneesParcelleCible);
            AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
        }
    }

    private class EcouteurBoutonIrriguer
    implements ActionListener {
        private EcouteurBoutonIrriguer() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.jeu.irriguer(AfficheurTerrain.this.coordonneesParcelleCible);
            AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
        }
    }

    private class EcouteurBoutonRecolter
    implements ActionListener {
        private EcouteurBoutonRecolter() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.jeu.recolter(AfficheurTerrain.this.coordonneesParcelleCible);
            AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
        }
    }

    private class EcouteurBoutonPlanter
    implements ActionListener {
        private EcouteurBoutonPlanter() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.planterClic = true;
            AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
        }
    }

    private class EcouteurBoutonParcelle
    implements ActionListener {
        private EcouteurBoutonParcelle() {
        }

        public void actionPerformed(ActionEvent event) {
            BoutonParcelle bouton = (BoutonParcelle)event.getSource();
            AfficheurTerrain.this.coordonneesParcelleCible = bouton.getCoordonnees();
            AfficheurTerrain.this.generateLabelInformation(AfficheurTerrain.this.coordonneesParcelleCible);
            AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
        }
    }

    private class EcouteurBoutonPlanterValider
    implements ActionListener {
        private EcouteurBoutonPlanterValider() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AfficheurTerrain.this.choixPlanter != null) {
                if (AfficheurTerrain.this.choixPlanter.equals("radis")) {
                    AfficheurTerrain.this.jeu.planter(AfficheurTerrain.this.coordonneesParcelleCible, new Radis());
                } else if (AfficheurTerrain.this.choixPlanter.equals("tomate")) {
                    AfficheurTerrain.this.jeu.planter(AfficheurTerrain.this.coordonneesParcelleCible, new Tomate());
                } else if (AfficheurTerrain.this.choixPlanter.equals("riz")) {
                    AfficheurTerrain.this.jeu.planter(AfficheurTerrain.this.coordonneesParcelleCible, new Riz());
                }
                AfficheurTerrain.this.labelInfoMangeable.setVisible(false);
                AfficheurTerrain.this.labelInfoMangeable.repaint();
                ((JPanel)AfficheurTerrain.this.labelInfoMangeable.getParent()).revalidate();
                AfficheurTerrain.this.generateBoutonsActions(AfficheurTerrain.this.coordonneesParcelleCible);
            }
        }
    }

    private class EcouteurBoutonMangerRiz
    implements ActionListener {
        private EcouteurBoutonMangerRiz() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.besoinManger--;
            AfficheurTerrain.this.jeu.manger(new Riz());
            AfficheurTerrain.this.panelManger.removeAll();
            AfficheurTerrain.this.panelManger.repaint();
            if (AfficheurTerrain.this.jeu.getNombreRadis() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerRadis);
            }
            if (AfficheurTerrain.this.jeu.getNombreTomates() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerTomate);
            }
            if (AfficheurTerrain.this.jeu.getNombreRiz() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerRiz);
            }
            System.out.println(AfficheurTerrain.this.besoinManger);
            if (AfficheurTerrain.this.besoinManger == 0) {
                AfficheurTerrain.this.panelInformations.remove(AfficheurTerrain.this.panelManger);
                AfficheurTerrain.this.panelInformations.repaint();
                AfficheurTerrain.this.boutonPasserTour.setVisible(true);
                AfficheurTerrain.this.panelPlanter.setVisible(false);
                AfficheurTerrain.this.labelInfoParcelle.setVisible(true);
                AfficheurTerrain.this.panelActionsBoutons.setVisible(true);
                AfficheurTerrain.this.jeu.passerTour();
            }
        }
    }

    private class EcouteurBoutonMangerTomate
    implements ActionListener {
        private EcouteurBoutonMangerTomate() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.besoinManger--;
            AfficheurTerrain.this.jeu.manger(new Tomate());
            AfficheurTerrain.this.panelManger.removeAll();
            AfficheurTerrain.this.panelManger.repaint();
            if (AfficheurTerrain.this.jeu.getNombreRadis() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerRadis);
            }
            if (AfficheurTerrain.this.jeu.getNombreTomates() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerTomate);
            }
            if (AfficheurTerrain.this.jeu.getNombreRiz() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerRiz);
            }
            if (AfficheurTerrain.this.besoinManger == 0) {
                AfficheurTerrain.this.panelInformations.remove(AfficheurTerrain.this.panelManger);
                AfficheurTerrain.this.panelInformations.repaint();
                AfficheurTerrain.this.boutonPasserTour.setVisible(true);
                AfficheurTerrain.this.panelPlanter.setVisible(false);
                AfficheurTerrain.this.labelInfoParcelle.setVisible(true);
                AfficheurTerrain.this.panelActionsBoutons.setVisible(true);
                AfficheurTerrain.this.jeu.passerTour();
            }
        }
    }

    private class EcouteurBoutonMangerRadis
    implements ActionListener {
        private EcouteurBoutonMangerRadis() {
        }

        public void actionPerformed(ActionEvent e) {
            AfficheurTerrain.this.besoinManger--;
            AfficheurTerrain.this.jeu.manger(new Radis());
            AfficheurTerrain.this.panelManger.removeAll();
            AfficheurTerrain.this.panelManger.repaint();
            if (AfficheurTerrain.this.jeu.getNombreRadis() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerRadis);
            }
            if (AfficheurTerrain.this.jeu.getNombreTomates() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerTomate);
            }
            if (AfficheurTerrain.this.jeu.getNombreRiz() > 0) {
                AfficheurTerrain.this.panelManger.add(AfficheurTerrain.this.boutonMangerRiz);
            }
            if (AfficheurTerrain.this.besoinManger == 0) {
                AfficheurTerrain.this.panelInformations.remove(AfficheurTerrain.this.panelManger);
                AfficheurTerrain.this.panelInformations.repaint();
                AfficheurTerrain.this.boutonPasserTour.setVisible(true);
                AfficheurTerrain.this.panelPlanter.setVisible(false);
                AfficheurTerrain.this.labelInfoParcelle.setVisible(true);
                AfficheurTerrain.this.panelActionsBoutons.setVisible(true);
                AfficheurTerrain.this.jeu.passerTour();
            }
        }
    }

    private class ItemState
    implements ItemListener {
        private ItemState() {
        }

        public void itemStateChanged(ItemEvent e) {
            AfficheurTerrain.this.choixPlanter = "";
            if (e.getItem() != null) {
                AfficheurTerrain.this.choixPlanter = e.getItem().toString().toLowerCase();
                if (AfficheurTerrain.this.typeMangeable(AfficheurTerrain.this.choixPlanter) != null) {
                    Mangeable m = AfficheurTerrain.this.typeMangeable(AfficheurTerrain.this.choixPlanter);
                    AfficheurTerrain.this.labelInfoMangeable.setVisible(true);
                    AfficheurTerrain.this.labelInfoMangeable.setText("<html><font color=\"white\">R\u00e9colte : " + m.getRendement() + " l\u00e9gumes<br>" + "Croissance : " + m.getCycleDeCroissance() + " tours</font></html>");
                }
                AfficheurTerrain.this.listePlanter.revalidate();
                AfficheurTerrain.this.labelInfoMangeable.revalidate();
                ((JPanel)AfficheurTerrain.this.labelInfoMangeable.getParent()).revalidate();
            }
        }
    }
}

