/*
 * Decompiled with CFR 0.152.
 */
package vue.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class BoutonMenu
extends JButton
implements MouseListener {
    private String name;
    private Graphics2D g2d;
    private boolean on;
    private int stringWidth;
    private int stringHeight;

    public BoutonMenu(String str) {
        super(str);
        this.name = str;
        this.setMargin(null);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setPreferredSize(new Dimension(90, 50));
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics g) {
        this.g2d = (Graphics2D)g;
        if (this.on) {
            this.g2d.setColor(Color.white);
            this.on = false;
        } else {
            this.g2d.setColor(Color.GRAY);
        }
        FontMetrics metrics = new FontMetrics(this.getFont()){};
        Rectangle2D bounds = metrics.getStringBounds(this.name, null);
        if ((int)bounds.getWidth() > this.stringWidth) {
            this.stringWidth = (int)bounds.getWidth();
        }
        if ((int)bounds.getHeight() > this.stringHeight) {
            this.stringHeight = (int)bounds.getHeight();
        }
        this.g2d.drawString(this.name, this.getWidth() / 2 - this.stringWidth / 2, this.getHeight() / 2 + this.stringHeight / 2);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.on = true;
    }

    public void mouseExited(MouseEvent e) {
        this.on = false;
    }
}

