/*
 * Decompiled with CFR 0.152.
 */
package vue.swing;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Sprites {
    private BufferedImage[] sprites;

    public Sprites(String filename) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL file = classLoader.getResource(filename);
        try {
            BufferedImage bigImg = ImageIO.read(file);
            int width = 100;
            int height = 100;
            int cols = 6;
            int rows = 7;
            this.sprites = new BufferedImage[cols * rows];
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    this.sprites[i * rows + j] = bigImg.getSubimage(i * width, j * height, width, height);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getSprite(int indice) {
        return this.sprites[indice];
    }
}

